package ch.frankel.blog.proxy;

import static org.testng.Assert.assertTrue;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

/**
 * Test class for class {@link NoOpAddInvocationHandler}.
 * 
 * @author <a href="http://blog.frankel.ch/">Nicolas Frankel</a>
 */
public class NoOpAddInvocationHandlerTest {

    /** Object to be proxied. */
    private List<Object> list;

    /** Proxy object. */
    private List<Object> proxy;

    /**
     * Creates the proxied object.
     */
    @BeforeMethod
    public void setUp() {

        // Object to be proxied
        list = new ArrayList<Object>(0);
    }

    /**
     * Test method for
     * {@link NoOpAddInvocationHandler#invoke(Object, Method, Object[])}.
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testInvoke() {

        proxy = (List) Proxy.newProxyInstance(NoOpAddInvocationHandlerTest.class.getClassLoader(),
                new Class[] { List.class }, new NoOpAddInvocationHandler(list));

        // and also a proxy
        assertTrue(proxy instanceof Proxy);
    }

    /**
     * Test the add method.
     */
    @Test(dependsOnMethods = "testInvoke")
    public void testAdd() {

        proxy.add(new Object());

        assertTrue(list.isEmpty());
    }
}
